function [polyup, polylow, Aup, Alow] = discharge_Area( X, Y, Xdup, Ydup, Xdlow, Ydlow )
%This function identifies the shape of the trapped volume connection to the
%delivery and suction relief grooves. Their shape is stored in 'polyshape'
%elements.
%INPUT
% X, Y : coordinates of the trapped volume shape (resulting from function 'create_polygon.m')
% Xup, Yup : coordinates of the rectangular shape representing delivery
%            relief groove
% Xdown, Ydown : coordinates of the rectangular shape representing suction
%                relief groove
%OUTPUT:
% polyup : 'polyshape' element representing delivery connection shape
% polylow : 'polyshape' element representing suction connection shape
% Aup : delivery connection area [mm2]
% Alow : suction connection area [mm2]

B = unique([X', Y'],'rows', 'stable');  %X,Y vectors duplicate points are cropped out
X = B(:, 1); Y = B(:, 2);               

trapp = polyshape(X, Y);          %trapped volume is converted in a 'polyshape' element
d_up = polyshape(Xdup, Ydup);     %delivery and suction rectangular relief grooves 
d_low = polyshape(Xdlow, Ydlow);  %are converted in 'polyshape' elements

polyup = intersect(trapp, d_up);    %'polyshape' elements are easily intersected thanks to                         
polylow = intersect(trapp, d_low);  %MATLAB 'intersect' function

Aup = area(polyup);    %'polyshape' elements areas are easily evaluated thanks to 
Alow = area(polylow);  %MATLAB 'area' function

end